package abstraction;
/**
 * @author Chiara Coccia, Diego Colarullo
 * @version 1.2 09/03/20
 * @since JDK 1.6
 */
import java.util.*;

import abstraction.Service;

/**
 * 
 * This Class manages a community, an ArrayList of Avalialble Service
 */

public class AvailableServices implements Cloneable {
	
	private ArrayList<Service> availableService;
	
	public AvailableServices(){	
		availableService= new ArrayList<Service>();
	}
	
	/**
	 * Method to add a service in Community
	 * @param toAdd service to add
	 * @return boolean. True if the service is added with successful, false otherwise
	 */	
	public boolean addService(Service toAdd){
		boolean check=false;
		if(toAdd.getStates().hasNext() && toAdd.getFinalStates().hasNext()){
			this.availableService.add(toAdd);
			check=true;
		}
		return check;
	}	
	
	/**
	 * Method to delete a service from Community
	 * @param index of the service to delete
	 */
	public void deleteService(int index){
		this.availableService.remove(index);
	}
	
	/**
	 * Method to delete all Community
	 * @param community to delete
	 * @return boolean. True community is deleted with successful, false otherwise
	 */
	public boolean deleteAllCommunity(AvailableServices community){
		boolean check;   
		this.availableService.clear();
			if(this.availableService.size()==0)
				check=true;
			else
				check=false;
			return check;
	}		
	
	/**
	 * This method says how many services there are inside a community
	 * @return int with community's size
	 */	
	public int sizeCommunity(){		
		return this.availableService.size();
	}	
	
	/**
	 * This method checks if community contains a service
	 * @param service to check if it is into community
	 * @return boolean. True community is deleted with successful, false otherwise
	 */	
	public boolean containService(Service service){
		return this.availableService.contains(service);
	}	
	
    /**
     * Returns the element at the specified position in this list.
     *
     * @param  index index of the element to return
     * @return the element at the specified position in this list
     * @throws IndexOutOfBoundsException
     */
	public Service get(int index){
		return availableService.get(index);
	}		
	
	// override of toString method to print a Community 
	public String toString(){
		return ""+this.availableService;
	}
	
    // override of clone method to clone a Community 
	@SuppressWarnings("unchecked")
	public Object clone() {
		try {
			AvailableServices c = (AvailableServices)super.clone();
			c.availableService = (ArrayList<Service>)availableService.clone();					
			return c;
		} 
		catch (CloneNotSupportedException e) {
			throw new InternalError(e.toString());
		}
	}	
	
	/**
	 * Method gets enumerator on key of hashtable Community
	 * @return a type Enumeration
	 */
	public Iterator<Service> getIterator(){
		return new OnlyReadIterator<Service>(this.availableService.iterator());
	}	
	
	/**
	 * Method gets position of service 
	 * @return int, service's position
	 */
	public int getPosition(Service toFind){
		return this.availableService.indexOf(toFind);
	}	
	
}
